﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Serialization;

namespace GraphicChart.Core
{

    /// <summary>
    /// Premenne pre kazdy jednotlivy graf
    /// Premenne su inicializovane na default hodnoty, pricom su nasledne prepisane hodnotami z XML ak take hodnoty existuju
    /// </summary>
    public class ChartVariables
    {

        public int ID { get; set; }                 // ID grafu
        public string ChartType { get; set; }       // Typ grafu
        public string XData { get; set; }           // Cislo stlpca od 0, ktory sa ma vybrat ako zdroj dat pre X
        public string YData { get; set; }           // Cislo stlpca od 0, ktory sa ma vybrat ako zdroj dat pre Y

        public string AlternativeChartFirst { get; set; }       // Cislo stlpca od 0, ktory sa ma pripojit spojit
        public string AlternativeChartSecond { get; set; }      // Cislo stlpca od 0, ktory sa ma pripojit spojit

        public bool IsXDataDateTime { get; set; }   // Ci je Xova os datum
        public string DateTimeSource { get; set; }  // Pozicia riadku, ktory je DateTime
        public string PositionRow { get; set; }     // Pozicia riadku, kde sa ma zobrazit graf
        public string PositionColumn { get; set; }  // Pozicia bunky, kde sa zobrazi graf
        public string ChartHeading { get; set; }    // Nadpis grafu
        public bool ShowDescription { get; set; }   // Cisa ma zobrazit popisok grafu
        public int ChartWidth { get; set; }         // Sirka grafu
        public int ChartHeight { get; set; }        // Vyska grafu   

        //nenastavuje sa z XML

        /// <summary>
        /// Granularita
        /// </summary>
        private string granularity = "month";
        public string Granularity
        {
            get { return granularity; }
            set { granularity = value; }
        }

        /// <summary>
        /// Ci sa maju vykreslit alternativne grafy
        /// </summary>
        private List<string> alternativeList = null;
        public List<string> AlternativeList
        {
            get { return alternativeList; }
            set { alternativeList = value; }
        }

        /// <summary>
        /// Ci sa ma prpenut do rezimu ScaleBreaks
        /// </summary>
        private bool scaleBreaks = false;
        public bool ScaleBreaks
        {
            get { return scaleBreaks; }
            set { scaleBreaks = value; }
        }

        /// <summary>
        /// Ci sa ma prpenut do rezimu ScaleBreaks
        /// </summary>
        private Point scaleBreaksClick = new Point();
        public Point SaleBreaksClick
        {
            get { return scaleBreaksClick; }
            set { scaleBreaksClick = value; }
        }
      
    }
}
